#include <algorithm>
#include <cstdio>
#include <iostream>
#include <stack>

struct Offer {
  int idx;
  int weight;
  int value;
} pom;

// std::vector<Offer> offers;
bool sortByIndex(const Offer &a, const Offer &b) { return a.idx < b.idx; }
bool sortByWeightDescending(const Offer &a, const Offer &b) {
  return a.weight > b.weight;
}

Offer offers[301];
int dp[301][(1 << 20)];
int main() {
  int n, W;
  float epsilon;
  std::cin >> n >> W >> epsilon;

  for (int i = 1, w, v; i <= n; i++) {
    pom.idx = i;
    std::cin >> pom.weight >> pom.value;
    offers[i] = pom;
  }
  std::sort(offers + 1, offers + (sizeof(offers) / sizeof(offers[0])),
            sortByWeightDescending);

  for (int i = 1; i <= n; i++) {
    for (int w = 1; w <= W; w++) {
      if (offers[i].weight > w) {
        dp[i][w] = dp[i - 1][w];
        continue;
      }
      dp[i][w] = std::max(dp[i - 1][w],
                          dp[i - 1][w - offers[i].weight] + offers[i].value);
    }
  }

  // for (int i = 0; i <= n; i++) {
  //   printf("i: %d v: %d w: %d\n", i, offers[i].value, offers[i].weight);
  // }
  //
  // for (int i = 0; i <= n; i++) {
  //   printf("%-2d: ", i);
  //   for (int w = 0; w <= W; w++) {
  //     printf("%-2d ", dp[i][w]);
  //   }
  //   puts("");
  // }

  std::stack<int> rez;
  {
    int i = n;
    int w = W;

    while (true) {
      if (dp[i][w] == 0)
        break;

      if (dp[i - 1][w] != dp[i][w]) {
        w -= offers[i].weight;
        rez.push(i);
      }
      i--;
    }
  }
  std::cout << rez.size() << "\n";
  while (!rez.empty()) {
    // printf("rez: %d\n", offers[rez.top()].idx);
    std::cout << offers[rez.top()].idx << " ";
    rez.pop();
  }

  return 0;
}